(function () {
    function initEffects() {
    if (typeof ahsHolidayData === 'undefined') return;

    var data = ahsHolidayData || {};
    var groups = data.effect_groups || [];
    var defaults = data.assets_defaults || {};

    if (!Array.isArray(groups) || groups.length === 0) return;

    var container = document.getElementById('ahs-effect-container');
    if (!container) return;

    function rand(min, max) {
        return min + Math.random() * (max - min);
    }

    function pick(arr) {
        return arr[Math.floor(Math.random() * arr.length)];
    }

    groups.forEach(function (g) {
        if (!g || !g.type) return;

        var type = g.type;
        var count = parseInt(g.count, 10);
        if (!count || count < 1) {
            count = (type === 'snow') ? 120 : (type === 'leaves' ? 80 : 60);
        }

        var items = Array.isArray(g.items)
    ? g.items.slice()
    : ((typeof g.items === 'string' && g.items.trim()) ? [g.items.trim()] : []);


        // If user didnt provide items, use built-in defaults for leaves/flag
        if (items.length === 0 && type === 'leaves' && defaults.leaves) items = defaults.leaves;
        if (items.length === 0 && type === 'flag' && defaults.flag) items = defaults.flag;

        for (var i = 0; i < count; i++) {
            var span = document.createElement('span');
            span.className = 'ahs-particle ahs-particle-' + type;
            span.style.left = rand(0, 100) + '%';
            span.style.animationDelay = rand(0, 10) + 's';
            span.style.animationDuration = rand(8, 20) + 's';

            if (type === 'snow') {
                span.textContent = '';
                span.style.fontSize = rand(6, 12) + 'px';
            } else {
                span.textContent = '';
                var url = (items.length > 0) ? pick(items) : '';

                // sizing
                if (type === 'flag') {
                    var w = rand(30, 50);
                    span.style.width = w + 'px';
                    span.style.height = (w * 2 / 3) + 'px';
                } else {
                    var s = rand(18, 34);
                    span.style.width = s + 'px';
                    span.style.height = s + 'px';
                }

                if (url) {
                    span.style.backgroundImage = 'url(' + url + ')';
                }
            }

            container.appendChild(span);
        }
    });
}


    function initModal() {
        var modal = document.getElementById('ahs-holiday-modal');
        if (!modal) {
            return;
        }

        var closeBtn = modal.querySelector('.ahs-modal-close');

        function closeModal() {
            modal.style.display = 'none';
        }

        if (closeBtn) {
            closeBtn.addEventListener('click', function (e) {
                e.preventDefault();
                closeModal();
            });
        }

        modal.addEventListener('click', function (e) {
            if (e.target === modal) {
                closeModal();
            }
        });
    }

    function init() {
        initEffects();
        initModal();
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
